/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aetherfabric.registries;

import com.aetherteam.aetherfabric.network.payload.KnownRegistryDataMapsPayload;
import com.aetherteam.aetherfabric.network.payload.KnownRegistryDataMapsReplyPayload;
import com.aetherteam.aetherfabric.network.payload.RegistryDataMapSyncPayload;
import com.aetherteam.aetherfabric.pond.FullDataMapAccess;
import com.aetherteam.aetherfabric.registries.RegistryManager;
import com.aetherteam.aetherfabric.registries.datamaps.DataMapsUpdatedEvent;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.client.networking.v1.ClientConfigurationNetworking;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_124;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_8710;
import org.slf4j.Logger;

public class ClientRegistryManager {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static <R> void handleDataMapSync(RegistryDataMapSyncPayload<R> payload, ClientPlayNetworking.Context context) {
        try {
            class_5455 regAccess = class_310.method_1551().field_1687.method_30349();
            FullDataMapAccess registry = (FullDataMapAccess)regAccess.method_30530(payload.registryKey());
            registry.setDataMaps(dataMaps -> payload.dataMaps().forEach((attachKey, maps) -> dataMaps.put(RegistryManager.getDataMap(payload.registryKey(), attachKey), Collections.unmodifiableMap(maps))));
            ((DataMapsUpdatedEvent.CallBack)DataMapsUpdatedEvent.EVENT.invoker()).onUpdate(new DataMapsUpdatedEvent(regAccess, regAccess.method_30530(payload.registryKey()), DataMapsUpdatedEvent.UpdateCause.CLIENT_SYNC));
        }
        catch (Throwable t) {
            LOGGER.error("Failed to handle registry data map sync: ", t);
            context.responseSender().disconnect((class_2561)class_2561.method_43469((String)"neoforge.network.data_maps.failed", (Object[])new Object[]{payload.registryKey().method_29177().toString(), t.toString()}));
        }
    }

    public static void handleKnownDataMaps(KnownRegistryDataMapsPayload payload, ClientConfigurationNetworking.Context context) {
        record MandatoryEntry(class_5321<? extends class_2378<?>> registry, class_2960 id) {
        }
        Sets.SetView missingTheir;
        HashSet ourMandatory = new HashSet();
        RegistryManager.getDataMaps().forEach((reg, values) -> values.values().forEach(attach -> {
            if (attach.mandatorySync()) {
                ourMandatory.add(new MandatoryEntry((class_5321<? extends class_2378<?>>)reg, attach.id()));
            }
        }));
        HashSet theirMandatory = new HashSet();
        payload.dataMaps().forEach((reg, values) -> values.forEach(attach -> {
            if (attach.mandatory()) {
                theirMandatory.add(new MandatoryEntry((class_5321<? extends class_2378<?>>)reg, attach.id()));
            }
        }));
        ArrayList<class_5250> messages = new ArrayList<class_5250>();
        Sets.SetView missingOur = Sets.difference(ourMandatory, theirMandatory);
        if (!missingOur.isEmpty()) {
            messages.add(class_2561.method_43469((String)"neoforge.network.data_maps.missing_our", (Object[])new Object[]{class_2561.method_43470((String)missingOur.stream().map(e -> String.valueOf(e.id()) + " (" + String.valueOf(e.registry().method_29177()) + ")").collect(Collectors.joining(", "))).method_27692(class_124.field_1065)}));
        }
        if (!(missingTheir = Sets.difference(theirMandatory, ourMandatory)).isEmpty()) {
            messages.add(class_2561.method_43469((String)"neoforge.network.data_maps.missing_their", (Object[])new Object[]{class_2561.method_43470((String)missingTheir.stream().map(e -> String.valueOf(e.id()) + " (" + String.valueOf(e.registry().method_29177()) + ")").collect(Collectors.joining(", "))).method_27692(class_124.field_1065)}));
        }
        if (!messages.isEmpty()) {
            class_5250 message = class_2561.method_43473();
            Iterator itr = messages.iterator();
            while (itr.hasNext()) {
                message = message.method_10852((class_2561)itr.next());
                if (!itr.hasNext()) continue;
                message = message.method_27693("\n");
            }
            context.responseSender().disconnect((class_2561)message);
            return;
        }
        HashMap known = new HashMap();
        RegistryManager.getDataMaps().forEach((key, vals) -> known.put((class_5321<? extends class_2378<?>>)key, (Collection<class_2960>)vals.keySet()));
        context.responseSender().sendPacket((class_8710)new KnownRegistryDataMapsReplyPayload(known));
    }
}

